<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        require_once __DIR__ . '/../../../../inc/conn.php';
        
        require_once __DIR__ . '/../../../inc/config.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        require_once __DIR__ . '/../../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/styles.php';

        $url = $_SERVER['REQUEST_URI'];
        preg_match('/users\/(\d+)/', $url, $matches);
        $user_id = $matches[1];

        $users_query = "SELECT * FROM users WHERE id = '$user_id'";
        $users_results = $conn->query($users_query);
        $user = $users_results->fetch_assoc();

    ?>

    <title><?php echo $user['name'] . ' | ' . $app['name']; ?></title>
    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/users/show.css'; ?>">

    <!-- Toasts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>

    <!-- Phone Mask -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>

</head>
<body>

    <?php require_once __DIR__ . '/../layout/leftbar.php'; ?>
    <div class="content__box">
        <form method="POST" onsubmit="Update(event)" id="user__form">
            <input type="hidden" value="<?php echo $user_id; ?>" name="id">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row__actions">
                            <h1 id="title" class="title"><?php echo $user['name']; ?></h1>
                            <button disabled id="save__button">Salvar</button>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="module module_flex">
                            <div class="input__box">
                                <label>Status <b>*</b></label>
                                <select required id="user__status" name="user[status]">
                                    <option <?php echo $user['status'] == 1 ? 'selected' : null; ?> value="1">Ativo</option>
                                    <option <?php echo $user['status'] == 0 ? 'selected' : null; ?> value="0">Inativo</option>
                                </select>
                            </div>
                            <div class="input__box">
                                <label>Plano <b>*</b></label>
                                <select required id="user__plan" name="user[plan]">
                                    <?php 
                                    $consulta = "SELECT name, recurrence, id FROM plans";
                                    $con = $conn->query($consulta) or die($conn->error);
                                    while($plan = $con->fetch_array()) { ?>
                                    <option value="<?php echo $plan['id'] ?>" <?php echo $user['plan'] == $plan['id'] ? 'selected' : ''; ?>><?php echo $plan['name'] . ' - ' . ucfirst($plan['recurrence']); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="module">
                            <div class="input__box">
                                <label>Nome <b>*</b></label>
                                <input required type="text" value="<?php echo !empty($user['name']) ? $user['name'] : '' ?>" id="user__name" name="user[name]">
                            </div>
                            <div class="input__box">
                                <label>E-mail <b>*</b></label>
                                <input required type="email" value="<?php echo !empty($user['mail']) ? $user['mail'] : '' ?>" id="user__mail" name="user[mail]">
                            </div>
                            <div class="input__box">
                                <label>Telefone</label>
                                <input type="tel" value="<?php echo !empty($user['telephone']) ? $user['telephone'] : '' ?>" id="user__telephone" name="user[telephone]">
                            </div>
                        </div>
                    </div>
                    <div class="col-8">
                        <div class="module">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Fatura</th>
                                        <th>Plano</th>
                                        <th>Preço</th>
                                        <th>Data</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $consulta = "SELECT * FROM invoices WHERE user = '$user_id' ORDER BY created_at DESC";
                                    $con = $conn->query($consulta) or die($conn->error);

                                    if ($con->num_rows > 0) {
                                        while($invoice = $con->fetch_array()) { ?>
                                        <tr>
                                            <td><?php echo $invoice['id']; ?></td>
                                            <td><?php echo $invoice['invoice']; ?></td>
                                            <td><?php echo $invoice['description']; ?></td>
                                            <td><?php echo $invoice['price']; ?></td>
                                            <td><?php echo date('d/m/Y', strtotime($invoice['created_at'])); ?></td>
                                        </tr>
                                        <?php } 
                                    } else { ?>
                                        <tr class="nothing">
                                            <td style="text-align: center;" colspan="5">Nenhuma fatura encontrada.</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

</body>
<script type="text/javascript">

    var notyf = new Notyf();

    function Update(event) {
        event.preventDefault();

        // Inicia o load
        const button = document.getElementById('save__button');
        button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Declara o form
        const user__form = document.getElementById('user__form');
        const form__data = new FormData(user__form);

        const phoneNumber = iti.getNumber();
        form__data.set('telephone', phoneNumber);

        // Envia o ajax
        $.ajax({
            type: "POST",
            url: base_url + "/api/user/update.php",
            data: form__data,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);

                // Sucesso
                if (response.status === 'success') {

                    const title = document.getElementById('title');
                    const name = document.getElementById('user__name');
                    title.innerHTML = name.value;

                    button.innerHTML = 'Salvar';
                    button.disabled = true;

                    notyf.success('Atualizado!');

                } else { // Erro

                }

            },
            error: function(xhr, status, error) {
                console.error("Erro:", error);
            }
        });

    }
    
    $(document).ready(function() {
        const $form = $('#user__form');
        const $submitButton = $('#save__button');

        var initialData = $form.serialize();

        $form.on('input change', function() {
            const currentData = $form.serialize();
            if (currentData !== initialData) {
                $submitButton.prop('disabled', false);
            } else {
                $submitButton.prop('disabled', true);
            }
        });
    });

    var phoneInput = document.querySelector("#user__telephone");
    iti = window.intlTelInput(phoneInput, {
        initialCountry: "auto",
        geoIpLookup: function(success, failure) {
            success('br');
        },
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js",
    });

</script>
</html>