<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php 

		$page_name = 'Login';

		require_once __DIR__ . '/../../../../inc/conn.php';
		
		require_once __DIR__ . '/../../../inc/config.php';
		require_once __DIR__ . '/../../../inc/styles.php';

		require_once __DIR__ . '/../../../../inc/cdns.php';

		if (isset($_SESSION['admin'])) {
			echo '<script>window.location.href=base_url</script>';
		}

	?>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/auth/login.css'; ?>">

</head>
<body>
	<div class="content__box">
		<div class="container">
			<div class="row">
				<div class="col-4 mx-auto">
					<div class="auth__brand">
						<img src="<?php echo $local['assets'] . '/brands/logo_black.png'; ?>">
					</div>
					<div class="auth__box">
						<form method="POST" onsubmit="Auth(event)" id="auth__form">
							<div class="input__box">
								<label>Usuário <b>*</b></label>
								<input oninput="Verify('user')" placeholder="ex: jhon_doe" type="text" name="auth[user]" id="auth__user">
								<p class="message__error"></p>
							</div>
							<div class="input__box">
								<label>Senha <b>*</b></label>
								<input oninput="Verify('pass')" placeholder="Sua senha aqui" type="password" name="auth[pass]" id="auth__pass">
								<p class="message__error" id="pass__error"></p>
							</div>
							<div class="input__action">
								<button id="auth__button" form="auth__form">Entrar</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>
<script type="text/javascript">
	
	function Auth(event) {
		event.preventDefault();

		// Define as variáveis
		const input__user = document.getElementById('auth__user');
		const input__pass = document.getElementById('auth__pass');
		const button = document.getElementById('auth__button');	

		// Verifica os inputs
		if (Verify('all')) { return false; }

		// Inicia o load
		const old__value = button.innerHTML;
		button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

		// Envia o ajax
		$.ajax({
		    type: "POST",
		    url: base_url + "/api/auth/login.php",
		    data: { user: input__user.value, pass: input__pass.value },
		    success: function(response) {
		    	console.log(response);

		        // Sucesso no login
		        if (response.status === 'success') {
		        	window.location.href = base_url + '/users';

		        } else { // Erro no Login
		        	const message__error = document.getElementById('pass__error');
		        	input__pass.focus();
		        	input__pass.value = '';
		        	message__error.style.display = 'block';
		        	message__error.innerHTML = 'Usuário e/ou senha incorretos.';
		        	button.innerHTML = old__value;
		        }

		    },
		    error: function(xhr, status, error) {
		        console.error("Erro:", error);
		    }
		});

	}

	function Verify(method) {
		const input__user = document.getElementById('auth__user');
		const input__pass = document.getElementById('auth__pass');
		let error;

		// Verifica o input User
		if ((method === 'user' || method === 'all')) {
			if (input__user.value === '') {
				input__user.parentNode.classList.add('invalid');
				input__user.parentNode.querySelector('.message__error').innerHTML = 'Preencha este campo.';
				error = true;
			} else {
				input__user.parentNode.classList.remove('invalid');
			}
		}

		// Verifica o input Pass
		if ((method === 'pass' || method === 'all')) {
			if (input__pass.value === '') {
				input__pass.parentNode.classList.add('invalid');
				input__pass.parentNode.querySelector('.message__error').innerHTML = 'Preencha este campo.';
				error = true;
			} else {
				input__pass.parentNode.classList.remove('invalid');
			}
		}

		return error;
	}

</script>
</html>