<?php

    require_once __DIR__ . '/../inc/conn.php';

    $rotas = [

        '' => 'src/views/users/list.php',
        'users' => 'src/views/users/list.php',
        'projects' => 'src/views/projects/list.php',
        'financial' => 'src/views/financial/list.php',

        // Auth
        'login' => 'src/views/auth/login.php',

    ];

    $consulta = "SELECT id FROM users";
    $con = $conn->query($consulta) or die($conn->error);
    while($dado = $con->fetch_array()) {
        $rotas['users/' . $dado['id']] = 'src/views/users/show.php';
    }

    // Mapeia o URI
    function getNormalizedUri() {
        $scriptPath = dirname($_SERVER['SCRIPT_NAME']);
        $uri = substr($_SERVER['REQUEST_URI'], strlen($scriptPath));
        if (strpos($uri, '?') !== false) {
            $uri = substr($uri, 0, strpos($uri, '?'));
        }
        return trim($uri, '/');
    }

    // Mapeia o URI normalizado
    $uri = getNormalizedUri();

    // Conecta o URI com a rota
    if (array_key_exists($uri, $rotas)) {
        require $rotas[$uri];

    } else { require 'src/templates/404.php'; }

?>