<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Sell';

        if (session_status() === PHP_SESSION_NONE) { session_start(); }

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        $user_id = $_SESSION['user']['id'];

        $type = 'car';
        $code = 'f6fd1939bds31481d27ac4344a2aab58';

        // Verifica se já existe o veículo e insere
        $sql = "INSERT IGNORE INTO vehicles (code, seller, type) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $code, $user_id, $type);
        $stmt->execute();

        // Resgata os dados do veículo
        $query = "SELECT vehicles.*,
                         brands.name AS brand_name 

                         FROM vehicles 
                         LEFT JOIN brands ON brands.id = vehicles.brand

                         WHERE code = '$code'";

        $results = $conn->query($query);
        $vehicle = $results->fetch_assoc();

    ?>

    <script>

        var type = '<?php echo $type; ?>';
        var code = '<?php echo $code; ?>';

    </script>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/sell/new.css'; ?>">

</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="brand__header">
                    <img onclick="Route('')" class="logo" src="<?php echo $local['brands'] . '/inline-black-fill.png'; ?>">
                </div>
            </div>
            <div class="col-12">
                <div class="sell__header">
                    <div class="sell__rows">
                        <div data-step="1" class="header__title current__title">
                            <div class="title__item">
                                <div class="number">1</div>
                                <label class="text">Preencha os dados do veículo</label>
                            </div>
                            <div class="row__item"></div>
                        </div>
                        <div data-step="2" class="header__title" style="display: none;"></div>
                        <div data-step="3" class="header__title">
                            <div class="title__item">
                                <div class="number">2</div>
                                <label class="text">Destaque seu anúncio</label>
                            </div>
                            <div class="row__box">
                                <div id="row__three" class="row__item"></div>
                                <div class="row__item"></div>
                            </div>
                        </div>
                        <div data-step="4" class="header__title">
                            <div class="title__item">
                                <div class="number">3</div>
                                <label class="text">Envie as fotos do veículo</label>
                            </div>
                            <div class="row__item"></div>
                        </div>
                        <div data-step="5" class="header__title" style="display: none;"></div>
                        <div data-step="6" class="header__title">
                            <div class="title__item">
                                <div class="number">4</div>
                                <label class="text">Verifique e publique o seu anúncio</label>
                            </div>
                            <div class="row__box">
                                <div id="row__five" class="row__item"></div>
                                <div class="row__item"></div>
                            </div>
                        </div>
                    </div>
                    <div class="mobile__row__item">
                        <div id="mobile__row"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div style="margin-top: 15px;" class="col-12">
                <div id="step__one" data-step="1" class="step__box">
                    <form id="form__one">
                        <div class="module">
                            <div class="row">
                                <div class="col-12 col-lg-8 col-xl-6 mx-auto">
                                    <div class="module__header">
                                        <h1>Preencha os dados do veículo</h1>
                                        <p class="subtitle">Campos com asterisco (*) são obrigatórios.</p>
                                        <hr>
                                    </div>
                                    <div class="input__box">
                                        <label>Marca <b>*</b></label>
                                        <select required onchange="ListModels()" name="brand" id="one__brand">
                                            <option value="">Escolha uma marca...</option>
                                        </select>
                                    </div>
                                    <div class="input__box">
                                        <label>Modelo <b>*</b></label>
                                        <select disabled required onchange="CheckInput()" name="model" id="one__model">
                                            <option>Escolha um modelo...</option>
                                        </select>
                                    </div>
                                    <div class="input__mid">
                                        <div class="input__box">
                                            <label>Ano do modelo <b>*</b></label>
                                            <input type="text" disabled required class="year__mask" oninput="VerifyStep(2)" placeholder="ex: 2020" value="<?php echo !empty($vehicle['year_model']) ? $vehicle['year_model'] : null; ?>" name="year_model" id="one__year__model">
                                        </div>
                                        <?php if ($type != 'boat') { ?>
                                        <div class="input__box">
                                            <label>Ano de fabricação <b>*</b></label>
                                            <input type="text" disabled required class="year__mask" oninput="VerifyStep(2)" placeholder="ex: 2021" value="<?php echo !empty($vehicle['year_build']) ? $vehicle['year_build'] : null; ?>" name="year_build" id="one__year__build">
                                        </div>
                                        <?php } ?>
                                    </div>
                                    <div class="input__mid">
                                        <?php if ($type == 'car') { ?>
                                        <div class="input__box">
                                            <label>Transmissão <b>*</b></label>
                                            <select disabled required onchange="VerifyStep(2)" name="transmission" id="one__transmission">
                                                <option value="">Selecione...</option>
                                                <option <?php echo $vehicle['transmission'] == 'manual' ? 'selected' : null ?> value="manual">Manual</option>
                                                <option <?php echo $vehicle['transmission'] == 'automatic' ? 'selected' : null ?> value="automatic">Automática</option>
                                                <option <?php echo $vehicle['transmission'] == 'semi-automatic' ? 'selected' : null ?> value="semi-automatic">Semi-automática</option>
                                                <option <?php echo $vehicle['transmission'] == 'cvt' ? 'selected' : null ?> value="cvt">CVT</option>
                                                <option <?php echo $vehicle['transmission'] == 'dual-clutch' ? 'selected' : null ?> value="dual-clutch">Dupla Embreagem</option>
                                                <option <?php echo $vehicle['transmission'] == 'tiptronic' ? 'selected' : null ?> value="tiptronic">Tiptronic</option>
                                                <option <?php echo $vehicle['transmission'] == 'sequential' ? 'selected' : null ?> value="sequential">Sequencial</option>
                                            </select>
                                        </div>
                                        <?php } ?>
                                        <div class="input__box">
                                            <label>Combustível <b>*</b></label>
                                            <select disabled required onchange="VerifyStep(2)" name="fuel" id="one__fuel">
                                                <option value="">Selecione...</option>
                                                <option <?php echo $vehicle['fuel'] == 'gasoline' ? 'selected' : null ?> value="gasoline">Gasolina</option>
                                                <option <?php echo $vehicle['fuel'] == 'diesel' ? 'selected' : null ?> value="diesel">Diesel</option>
                                                <option <?php echo $vehicle['fuel'] == 'ethanol' ? 'selected' : null ?> value="ethanol">Etanol</option>
                                                <option <?php echo $vehicle['fuel'] == 'flex' ? 'selected' : null ?> value="flex">Flex</option>
                                                <option <?php echo $vehicle['fuel'] == 'electric' ? 'selected' : null ?> value="electric">Elétrico</option>
                                                <option <?php echo $vehicle['fuel'] == 'hybrid' ? 'selected' : null ?> value="hybrid">Híbrido</option>
                                                <option <?php echo $vehicle['fuel'] == 'cng' ? 'selected' : null ?> value="cng">Gás Natural (CNG)</option>
                                                <option <?php echo $vehicle['fuel'] == 'lpg' ? 'selected' : null ?> value="lpg">Gás Liquefeito de Petróleo (LPG)</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="input__mid">
                                        <?php if ($type == 'car') { ?>
                                        <div class="input__box">
                                            <label>Carroceria <b>*</b></label>
                                            <select disabled required onchange="VerifyStep(2)" name="body" id="one__body">
                                                <option value="">Selecione...</option>
                                                <option <?php echo $vehicle['body'] == 'sedan' ? 'selected' : null ?> value="sedan">Sedan</option>
                                                <option <?php echo $vehicle['body'] == 'hatchback' ? 'selected' : null ?> value="hatchback">Hatchback</option>
                                                <option <?php echo $vehicle['body'] == 'suv' ? 'selected' : null ?> value="suv">SUV</option>
                                                <option <?php echo $vehicle['body'] == 'crossover' ? 'selected' : null ?> value="crossover">Crossover</option>
                                                <option <?php echo $vehicle['body'] == 'coupe' ? 'selected' : null ?> value="coupe">Coupé</option>
                                                <option <?php echo $vehicle['body'] == 'convertible' ? 'selected' : null ?> value="convertible">Conversível</option>
                                                <option <?php echo $vehicle['body'] == 'wagon' ? 'selected' : null ?> value="wagon">Perua</option>
                                                <option <?php echo $vehicle['body'] == 'minivan' ? 'selected' : null ?> value="minivan">Minivan</option>
                                                <option <?php echo $vehicle['body'] == 'pickup_truck' ? 'selected' : null ?> value="pickup_truck">Caminhonete</option>
                                                <option <?php echo $vehicle['body'] == 'roadster' ? 'selected' : null ?> value="roadster">Roadster</option>
                                                <option <?php echo $vehicle['body'] == 'sportscar' ? 'selected' : null ?> value="sportscar">Carro Esportivo</option>
                                                <option <?php echo $vehicle['body'] == 'luxury_car' ? 'selected' : null ?> value="luxury_car">Carro de Luxo</option>
                                            </select>
                                        </div>
                                        <?php } ?>
                                        <div class="input__box">
                                            <label>Quilometragem <b>*</b></label>
                                            <input type="number" disabled required oninput="VerifyStep(2)" placeholder="Para novos veículos não preencha o campo" value="<?php echo isset($vehicle['mileage']) ? $vehicle['mileage'] : null; ?>" min="0" value="0" name="mileage" id="one__mileage">
                                        </div>
                                    </div>
                                    <div class="input__mid">
                                        <?php if ($type != 'boat') { ?>
                                        <div class="input__box">
                                            <label>Placa <b>*</b></label>
                                            <input type="text" disabled required oninput="VerifyStep(2)" value="<?php echo !empty($vehicle['plate']) ? $vehicle['plate'] : null; ?>" placeholder="ex: ABC123" name="plate" id="one__plate">
                                        </div>
                                        <?php } ?>
                                        <?php if ($type == 'car') { ?>
                                        <div class="input__box">
                                            <label>Portas <b>*</b></label>
                                            <input type="number" disabled required oninput="VerifyStep(2)" placeholder="Quantidade de portas" value="<?php echo !empty($vehicle['seats']) ? $vehicle['seats'] : null; ?>" min="0" name="seats" id="one__seats">
                                        </div>
                                        <?php } ?>
                                    </div>
                                    <div class="input__box">
                                        <label>Cor <b>*</b></label>
                                        <input type="text" disabled required oninput="VerifyStep(2)" placeholder="ex: Prata, Branco, Preto" value="<?php echo !empty($vehicle['color']) ? $vehicle['color'] : null; ?>" name="color" id="one__color">
                                    </div>
                                    <div class="info__box">
                                        Não é possível editar os dados do veículo após criar o anúncio, confirme os dados antes de continuar.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div id="step__two" data-step="2" class="step__box">
                    <div class="module">
                        <div class="row">
                            <div class="col-12 col-lg-9 col-xl-7 mx-auto">
                                <div class="module__header">
                                    <h1>Informe as condições do veículo</h1>
                                    <p class="subtitle">Selecione os itens que representam detalhes adicionais do seu veículo para despertar a atenção dos compradores.</p>
                                    <hr>
                                </div>
                                <div id="conditions__box" class="tag__box">
                                    <?php 
                                    $vehicle['conditions'] = !empty($vehicle['conditions']) ? json_decode($vehicle['conditions'], true) : [];
                                    foreach ($conditions[$type] as $condition) { ?>
                                    <span onclick="ToggleTag(this)" class="tag__item <?php echo in_array($condition, $vehicle['conditions']) ? 'tag__chosen' : null ?>"><?php echo $condition; ?></span>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="step__three" data-step="3" class="step__box">
                    <div class="module">
                        <div class="row">
                            <div class="col-12 col-lg-9 col-xl-7 mx-auto">
                                <div class="module__header">
                                    <h1>Informe os opcionais do seu veículo</h1>
                                    <p class="subtitle">Selecione os itens que representam detalhes adicionais do seu veículo para despertar a atenção dos compradores.</p>
                                    <hr>
                                </div>
                                <div id="additionals__box" class="tag__box">
                                    <?php 
                                    $vehicle['details'] = !empty($vehicle['details']) ? json_decode($vehicle['details'], true) : [];
                                    foreach ($additionals[$type] as $additional) { ?>
                                    <span onclick="ToggleTag(this)" class="tag__item <?php echo in_array($additional, $vehicle['details']) ? 'tag__chosen' : null ?>"><?php echo $additional; ?></span>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="step__four" data-step="4" class="step__box">
                    <form id="form__four" enctype="multipart/form-data">
                        <div class="module">
                            <div class="row">
                                <div class="col-12 col-lg-9 col-xl-7 mx-auto">
                                    <div class="module__header">
                                        <h1>Adicione as fotos do veículo</h1>
                                        <p class="subtitle">Inclua até 8 fotos do seu veículo e lembre-se que boas imagens são o segredo para uma venda de sucesso.</p>
                                        <hr>
                                    </div>
                                    <div class="picture__box">
                                        <div class="row justify-content-center gx-3">
                                            <?php 

                                            $photos = !empty($vehicle['photos']) ? json_decode($vehicle['photos'], true) : null;
                                            $folder = $local['attachments'] . '/vehicles/' . $code . '/';

                                            for ($pic=0; $pic < 8; $pic++) { 

                                                if (isset($photos[$pic])) {
                                                    $picture = $folder . $photos[$pic];
                                                }

                                            ?>
                                            <div class="col-6 col-md-4 col-lg-3">
                                                <div id="picture__<?php echo $pic; ?>" class="picture__item">
                                                    <div <?php echo isset($photos[$pic]) ? 'style="display: flex; background: url('."'".$picture."'".');"' : 'style="display: none;"' ?> class="picture__preview">
                                                        <div onclick="TrashPicture('picture__<?php echo $pic; ?>', <?php echo isset($photos[$pic]) ? "'$photos[$pic]'" : 'null' ?>)" class="trash__picture">
                                                            <i class="fa-solid fa-xmark"></i>
                                                        </div>
                                                    </div>
                                                    <div style="display: <?php echo isset($photos[$pic]) ? 'none' : 'flex' ?>;" onclick="Picture(this)" class="picture__inner">
                                                        <i class="fa-regular fa-image"></i>
                                                        <p>Adicionar</p>
                                                        <input type="file" onchange="ShowPicture('picture__<?php echo $pic; ?>', this)" accept="image/jpeg, image/png" name="picture[]">
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div id="step__five" data-step="5" class="step__box">
                    <form id="form__five" onsubmit="event.preventDefault();">
                        <button form="form__five" id="button__five" style="display: none;"></button>
                        <div class="module">
                            <div class="row">
                                <div class="col-12 col-lg-9 col-xl-7 mx-auto">
                                    <div class="module__header">
                                        <h1>Verifique os seus dados abaixo</h1>
                                        <p class="subtitle">Preencha ou atualize seus dados para continuar seu anúncio.</p>
                                        <hr>
                                    </div>
                                    <div class="input__box">
                                        <label>Nome <b>*</b></label>
                                        <input type="text" disabled value="<?php echo !empty($user['name']) ? $user['name'] : null; ?>" id="user__name">
                                    </div>
                                    <div class="input__box">
                                        <label>E-mail <b>*</b></label>
                                        <input type="email" disabled value="<?php echo !empty($user['email']) ? $user['email'] : null; ?>" id="user__name">
                                    </div>
                                    <div class="input__box">
                                        <label>Telefone <b>*</b></label>
                                        <input type="text" disabled value="<?php echo !empty($user['telephone']) ? $user['telephone'] : null; ?>" id="user__telephone">
                                    </div>
                                    <div class="input__check">
                                        <input class="form-check-input" onchange="ToggleInputBox(this, 'user__telephone')" checked type="checkbox" id="allow__telephone">
                                        <label for="allow__telephone">Exibir meu telefone no anúncio</label>
                                    </div>
                                    <div class="input__box">
                                        <label>Data de nascimento <b>*</b></label>
                                        <input type="date" required oninput="CheckValidity(this)" value="<?php echo !empty($user['birth']) ? $user['birth'] : null; ?>" id="user__birth" max="<?php echo date('Y-m-d', strtotime('-18 years')); ?>">
                                    </div>
                                    <div class="input__box">
                                        <label>CEP de localização do veículo <b>*</b></label>
                                        <input type="text" required oninput="CheckValidity(this)" value="<?php echo !empty($user['zipcode']) ? $user['zipcode'] : null; ?>" id="user__name">
                                    </div>
                                    <div class="input__mid">
                                        <div class="input__box">
                                            <label>Cidade <b>*</b></label>
                                            <input type="text" required oninput="CheckValidity(this)" value="<?php echo !empty($user['city']) ? $user['city'] : null; ?>" id="user__name">
                                        </div>
                                        <div class="input__box">
                                            <label>Estado <b>*</b></label>
                                            <input type="text" required oninput="CheckValidity(this)" value="<?php echo !empty($user['state']) ? $user['state'] : null; ?>" id="user__name">
                                        </div>
                                    </div>
                                    <div class="input__box">
                                        <label>Endereço <b>*</b></label>
                                        <input type="text" required oninput="CheckValidity(this)" value="<?php echo !empty($user['address']) ? $user['address'] : null; ?>" id="user__address">
                                    </div>
                                    <div class="input__check">
                                        <input class="form-check-input" onchange="ToggleInputBox(this, 'user__address')" checked type="checkbox" id="allow__address">
                                        <label for="allow__address">Exibir o endereço no anúncio</label>
                                    </div>
                                    <div style="margin-top: 35px;" class="info__box">
                                        Ao prosseguir, eu declaro ter ciência de que este cadastro é somente para maiores de 18 anos.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div id="step__six" data-step="6" class="step__box">
                    <div class="module">
                        <div class="row">
                            <div class="col-12 col-lg-9 col-xl-7 mx-auto">
                                <div class="module__header">
                                    <h1>Selecione um plano</h1>
                                    <p class="subtitle">Preencha ou atualize seus dados para continuar seu anúncio.</p>
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="step__footer">
                    <button onclick="Update(current__step, this, current__step - 1)" disabled id="prev__step">Voltar</button>
                    <button onclick="Update(current__step, this, current__step + 1)" id="next__step">Avançar</button>
                </div>
            </div>
        </div>
    </div>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.9/jquery.inputmask.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>
<script type="text/javascript">

    var current__step = 1;

    Step(4);

    // Atualiza no db
    function Update(step, button = null, useStep = null) {

        // Verifica os campos
        if (VerifyStep(step)) { 
            console.error('Step error: ' + step); 
            return false; 
        };

        // Load button
        if (button) {
            btn_value = button.innerHTML;
            button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';
        }

        var params = new FormData();

        params.append('type', type);
        params.append('code', code);
        params.append('step', step);

        let status = false;

        // Define params
        if (step === 1) {

            const form__one = document.getElementById('form__one');
            const form__data = new FormData(form__one);
            let data = {};

            form__data.forEach((value, key) => {
                data[key] = value;
            });

            params.append('params', JSON.stringify(data));
            status = true;

        } else if (step === 2) {
            params.append('params', GetConditions()); // Pega o json das condições
            status = true;

        } else if (step === 3) {
            params.append('params', GetAdditionals()); // Pega o json dos adicionais
            status = true;

        } else if (step === 4) {

            const form__four = document.getElementById('form__four');
            const form__data = new FormData();

            for (let i = 0; i < form__four.elements.length; i++) {
                if (form__four.elements[i].type === 'file') {
                    const fileInput = form__four.elements[i];
                    if (fileInput.files.length > 0) {
                        for (let j = 0; j < fileInput.files.length; j++) {
                            params.append(i, fileInput.files[j]);
                        }
                    }
                }
            }

            status = true;

        }

        // Envia o ajax
        if (status) {            
            $.ajax({
                type: "POST",
                url: base_url + "/api/sell/update.php",
                data: params,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);

                    if (response.status === 'success') {
                        useStep ? Step(useStep) : null;
                        status = true;

                    } else if (response.status === 'upload__error') {
                        // TODO

                    }

                },
                error: function(xhr, status, error) {
                    console.log(error);
                    status = false;
                },
                complete: function() {
                    if (button) { button.innerHTML = btn_value; }
                    return status;
                }
            });
        } else {
            if (button) { button.innerHTML = btn_value; }
            return false;
        }

    }

    // Muda os steps
    function Step(step) {

        current__step = step;
        window.scrollTo(0, 0);

        // Define os headers
        const headers = document.querySelectorAll('.header__title');
        if (step == 2 || step == 5) { step__header = step + 1; } else { step__header = step; }
        headers.forEach(header => {
            if (header.dataset.step == step__header) {
                header.classList.add('current__title');
            } else {
                header.classList.remove('current__title');
            }
        });

        // Ativa o step 2
        const row__three = document.getElementById('row__three');
        current__step > 2 ? row__three.classList.add('row__active') : row__three.classList.remove('row__active');

        // Ativa o step 5
        const row__five = document.getElementById('row__five');
        current__step > 5 ? row__five.classList.add('row__active') : row__five.classList.remove('row__active');

        // Atualiza o header mobile
        MobileStepRow(current__step);

        // Define os boxs
        const boxs = document.querySelectorAll('.step__box');
        boxs.forEach(box => {
            if (box.dataset.step == step) {
                box.classList.add('current__box');
            } else {
                box.classList.remove('current__box');
            }
        });

        // Gerencia os botões prev/next
        const prev__button = document.getElementById('prev__step');
        const next__button = document.getElementById('next__step');
        current__step > 1 ? prev__button.disabled = false : prev__button.disabled = true;
        current__step < 6 ? next__button.disabled = false : next__button.disabled = true;

        // Desativa os botões no ultimo step
        const step__footer = document.getElementById('step__footer');
        current__step === 6 ? step__footer.style.display = 'none' : step__footer.style.display = 'flex';
    }

    // Verifica se vai vincular o endereço
    function ToggleInputBox(checkbox, input_id) {
        const input = document.getElementById(input_id);
        if (checkbox.checked) {
            input.parentNode.style.display = 'block';
            input.disabled = false;
            input.focus();
        } else {
            input.parentNode.style.display = 'none';
            input.disabled = true;
        }
    }

    // Verifica os steps
    function VerifyStep(step__check) {
        var step__error = false;

        if (step__check === 1) {
            const form__one = document.getElementById('form__one');
            const fields = form__one.querySelectorAll('input, select, textarea');
            fields.forEach(field => {
                if (field.tagName === 'INPUT' || field.tagName === 'SELECT') {
                    if (field.value === '') {
                        field.classList.add('invalid');
                        step__error = true;
                    } else {
                        field.classList.remove('invalid');
                    }
                }
            });
        }

        if (step__check > 5) {
            const form__five = document.getElementById('form__five');
            const fields = form__five.querySelectorAll('input, select, textarea');
            fields.forEach(field => {
                if (field.tagName === 'INPUT' || field.tagName === 'SELECT') {
                    if (field.value === '' && field.disabled === false && field.required) {
                        field.classList.add('invalid');
                        step__error = true;
                    } else {
                        field.classList.remove('invalid');
                    }
                }
            });
        }

        return step__error;
    }

    // Verifica um input específico
    function CheckValidity(input) {
        if (input.value !== '' && input.required) {
            input.classList.remove('invalid');
        } else {
            input.classList.add('invalid');
        }
    }

    // Atualiza o background do mobile step
    function MobileStepRow(step) {
        const mobile__step = document.getElementById('mobile__row');
        const steps = document.querySelectorAll('.step__box');
        step !== 1 ? width = (step * 100) / steps.length : width = 0;
        mobile__step.style.width = width + '%';
        return mobile__step.style.width;
    }


    // =========== TAGS    

    // Marca as tags
    function ToggleTag(tag) {
        if (tag.classList.contains('tag__chosen')) {
            tag.classList.remove('tag__chosen');
        } else {
            tag.classList.add('tag__chosen');
        }
    }

    function GetAdditionals() {
        const elements = document.querySelectorAll('#additionals__box .tag__chosen');
        const tags = Array.from(elements).map(tag => tag.innerHTML);
        const jsonTags = JSON.stringify(tags);
        return tags.length > 0 ? jsonTags : null;
    }

    function GetConditions() {
        const elements = document.querySelectorAll('#conditions__box .tag__chosen');
        const tags = Array.from(elements).map(tag => tag.innerHTML);
        const jsonTags = JSON.stringify(tags);
        return tags.length > 0 ? jsonTags : null;
    }


    // =========== PICTURE

    // Adiciona o click no box da imagem
    function Picture(box) {
        const input = box.querySelector('input');
        input.click();
    }

    // Mostra o preview da imagem
    function ShowPicture(picture_id, input) {
        const preview__box = document.querySelector(`#${picture_id} .picture__preview`);
        const inner__box = document.querySelector(`#${picture_id} .picture__inner`);

        preview__box.style.display = 'flex';
        inner__box.style.display = 'none';

        // Criar um objeto FormData
        const formData = new FormData();
        formData.append('file', input.files[0]);

        $.ajax({
            type: "POST",
            url: "https://cdn.mymotorsusa.com/upload",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);
                if (response.status === 'success') {

                    $.ajax({
                        type: "POST",
                        url: base_url + "/api/sell/picture.php",
                        data: {
                            action: 'upload',
                            id: <?php echo $vehicle['id']; ?>,
                            link: response.files[0].link,
                        },
                        success: function(response) {
                            console.log(response);
                            preview__box.style.background = `url('${response.files[0].link}')`;
                        },
                        error: function(xhr, status, error) {
                            console.log(error);
                        }
                    });

                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });

    }

    // Remove a foto e reseta o preview
    function TrashPicture(box_id, filename) {
        const preview__box = document.querySelector(`#${box_id} .picture__preview`);
        const inner__box = document.querySelector(`#${box_id} .picture__inner`);
        const input = document.querySelector(`#${box_id} input`);

        if (filename) {
            $.ajax({
                type: "POST",
                url: base_url + "/api/sell/picture.php",
                data: {
                    action: 'trash',
                    code: code,
                    file: filename,
                },
                success: function(response) {
                    console.log(response);
                    preview__box.style.background = '';
                    preview__box.style.display = 'none';
                    inner__box.style.display = 'flex';
                    input.value = '';
                },
                error: function(xhr, status, error) {
                    console.log(error);
                }
            }); 
        } else {
            preview__box.style.background = '';
            preview__box.style.display = 'none';
            inner__box.style.display = 'flex';
            input.value = '';
        }
    }


    // =========== ASYNC FUNCTIONS

    // Libera os inputs pra preencher após selecionar o modelo
    function CheckInput() {
        const form = document.getElementById('form__one');
        const inputs = form.querySelectorAll('input, select');
        const brandSelect = document.getElementById('one__brand');
        const modelSelect = document.getElementById('one__model');
        if (modelSelect.value !== '') {
            if (brandSelect.tagName === 'INPUT') {
                const modelInput = document.createElement('input');
                modelInput.type = 'text';
                modelInput.id = 'one__brand';
                modelInput.placeholder = 'Defina o modelo do veículo';
                modelSelect.parentNode.appendChild(modelInput);
                modelSelect.remove();
            }

            inputs.forEach(input => {
                input.disabled = false;
            });
        } else {
            inputs.forEach(input => {
                input.disabled = true;
            });
        }
    }

    // Atualiza o select de modelos
    async function ListModels() {
        const makeInput = document.getElementById('one__brand');
        const modelSelect = document.getElementById('one__model');

        if (makeInput.value === '') { return false; }
        modelSelect.innerHTML = '<option value="">Carregando...</option>';

        const makeId = makeInput.options[makeInput.selectedIndex].dataset.id;

        try {
            const response = await fetch('https://vpic.nhtsa.dot.gov/api/vehicles/GetModelsForMakeId/' + makeId + '?format=json');
            const data = await response.json();

            if (data.Results) {
                const models = data.Results;
                models.sort((a, b) => a.Model_Name.localeCompare(b.Model_Name));

                modelSelect.innerHTML = '';
                modelSelect.disabled = false;

                models.forEach(model => {
                    const option = document.createElement('option');
                    option.selected = model.Model_Name == '<?php echo !empty($vehicle['model']) ? $vehicle['model'] : null ?>' ? true : false;
                    option.value = model.Model_Name;
                    option.text = model.Model_Name;
                    modelSelect.appendChild(option);
                });

                CheckInput();

            } else { console.error('Nenhum resultado encontrado'); }
        } catch (error) { console.error('Erro ao buscar dados:', error); }
    }

    document.addEventListener("DOMContentLoaded", function() {

        // Busca as marcas
        async function ListBrands() {
            const selectElement = document.getElementById('one__brand');
            selectElement.innerHTML = '<option value="">Carregando...</option>';

            try {
                const response = await fetch('https://vpic.nhtsa.dot.gov/api/vehicles/GetMakesForVehicleType/' + type + '?format=json');
                const data = await response.json();
                if (data.Results.length > 0) {
                    selectElement.innerHTML = '<option value="">Selecione a marca do veículo</option>';
                    PopulateBrands(data.Results);
                    selectElement.value !== '' ? ListModels() : null;
                } else {
                    const brandInput = document.createElement('input');
                    brandInput.type = 'text';
                    brandInput.id = 'one__brand';
                    brandInput.placeholder = 'Defina a marca do veículo';
                    selectElement.parentNode.appendChild(brandInput);
                    selectElement.remove();
                    CheckInput();
                    console.error('Nenhum resultado encontrado');
                }
            } catch (error) {
                console.error('Erro ao buscar dados:', error);
            }
        }

        // Atualiza o select das brands em ordem alfabética
        function PopulateBrands(makes) {
            const selectElement = document.getElementById('one__brand');
            makes.sort((a, b) => a.MakeName.localeCompare(b.MakeName));
            makes.forEach(make => {
                const option = document.createElement('option');
                option.selected = make.MakeName == '<?php echo !empty($vehicle['brand_name']) ? strtoupper($vehicle['brand_name']) : null ?>' ? true : false;
                option.dataset.id = make.MakeId;
                option.value = make.MakeName;
                option.textContent = make.MakeName;
                selectElement.appendChild(option);
            });
        }

        ListBrands();

        // Adiciona a mask no telefone
        var phoneInput = document.querySelector("#user__telephone");
        iti = window.intlTelInput(phoneInput, {
            initialCountry: "auto",
            geoIpLookup: function(success, failure) {
                success('us');
            },
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js",
        });

    });

    $(document).ready(function(){

        $('.money__mask').inputmask({
            alias: 'currency',
            prefix: '$ ',
            groupSeparator: '.',
            radixPoint: ',',
            autoGroup: true,
            digits: 0,
            rightAlign: false,
            placeholder: '0'
        });

        $('.mileage__mask').inputmask({
            alias: 'numeric',
            groupSeparator: '.',
            radixPoint: ',',
            autoGroup: true,
            digits: 0,
            rightAlign: false,
            placeholder: '0'
        });

        $('.year__mask').inputmask('9999',{ 
            placeholder: '', 
            clearIncomplete: true 
        });

    });

</script>
</html>