<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Login';
        $auth_page = true;

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        // verify login
        if (isAuth()) { Redirect(''); }

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/authentication/login.css'; ?>">

</head>
<body>
<?php require_once __DIR__ . '/../../templates/topbar.php'; ?>

    <div class="content__box">
        <div class="banner_bg"></div>
        <div class="login__box">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-5">
                        <div class="login__module">
                            <h1 class="title">Digite o seu e-mail e senha</h1>
                            <div class="input__box">
                                <label>E-mail <b>*</b></label>
                                <input type="email" value="usuario@mymotorsusa.com" oninput="InputVerify(this)" placeholder="ex: nome@email.com" required id="login__email" name="login[email]">
                                <p id="email__error" class="message__error"></p>
                            </div>
                            <div style="margin-top: 10px;" class="input__box">
                                <label>Senha <b>*</b></label>
                                <input type="password" value="Teste@123" oninput="InputVerify(this)" onkeydown="if(event.key === 'Enter'){ Login(); }" required id="login__password" name="login[password]">
                                <p id="password__error" class="message__error"></p>
                            </div>
                            <div class="input__links">
                                <a href="<?php echo Route('recovery'); ?>">Esqueci minha senha</a>
                            </div>
                            <div class="input__action">
                                <button id="login__button" onclick="Login()">Entrar</button>
                            </div>
                            <div class="input__info">
                                <p>Não tem uma conta? <a href="<?php echo Route('register'); ?>">Crie a sua</a></p>
                                <div id="status__error">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor.</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="info__contact">
                            <i class="fa-regular fa-circle-question"></i>
                            <p>Precida de ajuda?</p>
                            <a href="<?php echo Route('help'); ?>">Fale conosco</a>
                        </div>
                        <p class="info__text" style="margin-top: 20px;">Ao prosseguir você está ciente e concorda em receber comunicações da <?php echo $app['name']; ?>.</p>
                    </div>
                </div>
            </div>
        </div>    
    </div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>
</body>
<script type="text/javascript">

    function InputVerify(input) {
        if (input.value.length >= 3) {
            if (input.type === 'email') {
                const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                const message__error = document.getElementById('email__error');
                if (regex.test(input.value)) {
                    message__error.innerHTML = '';
                    input.classList.remove('invalid');
                    return true;
                } else { 
                    message__error.innerHTML = 'Email inválido!';
                    input.classList.add('invalid'); 
                    return false;
                }

            } else if (input.type === 'password') {
                const regex = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/;
                const message__error = document.getElementById('password__error');
                if (regex.test(input.value)) {
                    message__error.innerHTML = '';
                    input.classList.remove('invalid');
                    return true;
                } else { 
                    message__error.innerHTML = 'A senha deve ter pelo menos 8 caracteres, incluindo letras maiúsculas, minúsculas, números e símbolos.';
                    input.classList.add('invalid'); 
                    return false;
                }

            }
        } else {
            input.classList.add('invalid');
            return false;
        }
    }
    
    function Login() {

        const input__email = document.getElementById('login__email');
        const input__password = document.getElementById('login__password');
        const input__submit = document.getElementById('login__button');

        // Limpa a mensagem de erro
        const message__error = document.getElementById('status__error');
        message__error.style.display = 'none';
        message__error.innerHTML = '';

        // Reseta o botão
        const old__button = input__submit.innerHTML;
        input__submit.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Verifica se os campos foram preenchidos
        if (!InputVerify(input__email) || !InputVerify(input__password)) { 
            input__submit.innerHTML = old__button;
            return false; 
        }

        // Envia o ajax
        $.ajax({
            type: "POST",
            url: base_url + "/api/authentication/login.php",
            data: {
                email: input__email.value,
                password: input__password.value,
            },
            success: function(response) {
                if (response.status === 'success') {

                    // Verifica se tem link pra redirect
                    const redirect__link = getQueryParam('r');
                    !redirect__link ? Route('') : window.location.href = redirect__link;

                    input__submit.innerHTML = old__button;
                    message__error.style.display = 'none';                    
                    console.log(response);

                } else if (response.status === 'not_found') {

                    input__password.value = '';
                    input__password.focus();
                    input__submit.innerHTML = old__button;
                    message__error.style.display = 'block';
                    message__error.innerHTML = 'Usuário não encontrado. Por favor, verifique suas informações e tente novamente.';

                    console.log(response);

                } else {

                    input__password.value = '';
                    input__password.focus();
                    input__submit.innerHTML = old__button;
                    message__error.style.display = 'block';
                    message__error.innerHTML = 'Houve um problema ao verificar suas informações. Por favor, tente novamente mais tarde.';

                    console.log(response);
                }
            },
            error: function(xhr, status, error) {

                input__password.value = '';
                input__password.focus();
                input__submit.innerHTML = old__button;
                message__error.style.display = 'block';
                message__error.innerHTML = 'Houve um problema ao enviar seus dados. Por favor, verifique sua conexão e tente novamente.';

                console.error("login_error: ", error);

            }
        });

    }

</script>
</html>