<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Garage';

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        $user_id = $_SESSION['user']['id'];

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/account/garage.css'; ?>">

</head>
<body>
    
    <?php require_once __DIR__ . '/../../templates/topbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div style="margin-bottom: 20px;" class="col-12 col-md-4 col-lg-3">
                    <?php include_once __DIR__ . '/../../templates/account_menu.php'; ?>
                </div>
                <div class="col-12 col-md-8 col-lg-9">
                    <div id="garage__box">
                        <div class="garage__title">
                            <h1 id="title" class="title">Meus anúncios</h1>
                            <p id="subtitle" class="subtitle">Anuncie seu veículo e feche o melhor negócio!</p>
                            <hr>
                        </div>
                        <div class="garage__header">
                            <button class="row__active">Ativo</button>
                            <button>Em análise</button>
                            <button>Inativos</button>
                            <button>Incompletos</button>
                        </div>
                    </div>
                    <div id="garage__rows">
                        <div id="rows__car">
                            <div class="row gx-3">
                                
                            </div>
                        </div>
                        <div id="rows__motorcycle">
                            <div class="row gx-3">
                                
                            </div>
                        </div>
                        <div id="rows__boat">
                            <div class="row gx-3">
                                
                            </div>
                        </div>
                        <div id="rows__nothing">
                            <h1>Você ainda não tem anúncios.</h1>
                            <p>Anuncie seu veículo e feche o melhor negócio!</p>
                            <button onclick="Route('sell')">Criar anúncio</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

    var currentBox = 'car';

    function Toggle(box) {
        currentBox = box;

        const boxes = {
            car: document.getElementById('rows__car'),
            motorcycle: document.getElementById('rows__motorcycle'),
            boat: document.getElementById('rows__boat')
        };

        const buttons = {
            car: document.getElementById('button__car'),
            motorcycle: document.getElementById('button__motorcycle'),
            boat: document.getElementById('button__boats')
        };

        Object.values(boxes).forEach(box => box.style.display = 'none');
        Object.values(buttons).forEach(button => button.classList.remove('row__active'));

        if (boxes[box]) {
            boxes[box].style.display = 'block';
        }
        if (buttons[box]) {
            buttons[box].classList.add('row__active');
        }

        CheckNothing(boxes[box]);

    }

    function CheckNothing(toggle = false) {
        const boxNothing = document.getElementById('rows__nothing');
        if (toggle) {
            const elements = toggle.querySelectorAll('.vehicle__item');
            elements.length === 0 ? boxNothing.style.display = 'flex' : boxNothing.style.display = 'none';
        } else {
            const elements = document.querySelectorAll('.vehicle__item');
            elements.length === 0 ? boxNothing.style.display = 'flex' : boxNothing.style.display = 'none';
        }
    }

    function HoverPicture(action, file, box) {
        box.style.background = 'url("' + file + '")';
    }

    function Remove(id) {
        document.getElementById(id).remove();
        Toggle(currentBox);
    }

    // Conta os likes
    document.addEventListener('DOMContentLoaded', function() {
        CheckNothing();
    });

</script>
</html>