<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Favorites';

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        $user_id = $_SESSION['user']['id'];

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/account/favorites.css'; ?>">

</head>
<body>
    
    <?php require_once __DIR__ . '/../../templates/topbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div style="margin-bottom: 20px;" class="col-12 col-md-4 col-lg-3">
                    <?php include_once __DIR__ . '/../../templates/account_menu.php'; ?>
                </div>
                <div class="col-12 col-md-8 col-lg-9">
                    <div id="favorite__box">
                        <div class="favorite__title">
                            <h1 id="title" class="title">Meus favoritos</h1>
                            <p id="subtitle" class="subtitle">Gostou de um anúncio? Clica no coração que ele vem pra cá!</p>
                            <hr>
                        </div>
                        <div class="favorite__header">
                            <button id="button__car" onclick="Toggle('car', this)">Carro</button>
                            <button id="button__motorcycle" onclick="Toggle('motorcycle', this)">Moto</button>
                            <button id="button__boats" onclick="Toggle('boat', this)">Barco</button>
                        </div>
                    </div>
                    <div id="favorite__rows">
                        <div id="rows__car">
                            <div class="row gx-3">
                                <?php 

                                $consulta = "SELECT vehicles.*,
                                                    brands.name AS brand_name 

                                                    FROM vehicles 
                                                    LEFT JOIN brands ON brands.id = vehicles.brand

                                                    WHERE vehicles.status = 1
                                                    AND vehicles.type = 'car'
                                                    AND vehicles.id IN (SELECT vehicle FROM likes WHERE user = '$user_id')";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($vehicle = $con->fetch_array()) { 

                                    if (!empty($vehicle['photos'])) {
                                        $vehicle['photos'] = json_decode($vehicle['photos'], true);
                                        $attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
                                    }

                                ?>
                                <div id="<?php echo $vehicle['code']; ?>" class="col-6 col-lg-3 col-xl-3">
                                    <div class="vehicle__item">
                                        <div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
                                            <div 
                                                 <?php if (isset($vehicle['photos'][1])) { ?>
                                                 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
                                                 <?php } ?>

                                                 <?php if (isset($vehicle['photos'][0])) { ?>
                                                 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
                                                 <?php } ?>

                                                 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
                                                 class="picture__item"
                                            ></div>
                                        </div>
                                        <div class="vehicle__details">
                                            <h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
                                            <p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes"><?php echo strtoupper($vehicle['engine'] . ' ' . $vehicle['fuel'] . ' ' . $vehicle['transmission']); ?></p>
                                            <h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
                                            <div class="vehicle__statistics">
                                                <p class="vehicle__year">
                                                    <?php echo Year($vehicle); ?>
                                                </p>
                                                <p class="vehicle__mileage">
                                                    <?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
                                                </p>
                                            </div>
                                            <div class="vehicle__action">
                                                <button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
                                            </div>
                                        </div>
                                        <div class="vehicle__footer">
                                            <div class="vehicle__location">
                                                <?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
                                            </div>
                                            <div class="vehicle__icons">
                                                <span onclick="Like(<?php echo $vehicle['id'] ?>, this); Remove('<?php echo $vehicle['code'] ?>')" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
                                                    <?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
                                                    <?php } else { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
                                                    <?php } ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div id="rows__motorcycle">
                            <div class="row gx-3">
                                <?php 

                                $consulta = "SELECT vehicles.*,
                                                    brands.name AS brand_name 

                                                    FROM vehicles 
                                                    LEFT JOIN brands ON brands.id = vehicles.brand

                                                    WHERE vehicles.status = 1
                                                    AND vehicles.type = 'motorcycle'
                                                    AND vehicles.id IN (SELECT vehicle FROM likes WHERE user = '$user_id')";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($vehicle = $con->fetch_array()) { 

                                    if (!empty($vehicle['photos'])) {
                                        $vehicle['photos'] = json_decode($vehicle['photos'], true);
                                        $attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
                                    }

                                ?>
                                <div id="<?php echo $vehicle['code']; ?>" class="col-6 col-lg-3 col-xl-3">
                                    <div class="vehicle__item">
                                        <div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
                                            <div 
                                                 <?php if (isset($vehicle['photos'][1])) { ?>
                                                 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
                                                 <?php } ?>

                                                 <?php if (isset($vehicle['photos'][0])) { ?>
                                                 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
                                                 <?php } ?>

                                                 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
                                                 class="picture__item"
                                            ></div>
                                        </div>
                                        <div class="vehicle__details">
                                            <h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
                                            <p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes"><?php echo strtoupper($vehicle['engine'] . ' ' . $vehicle['fuel'] . ' ' . $vehicle['transmission']); ?></p>
                                            <h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
                                            <div class="vehicle__statistics">
                                                <p class="vehicle__year">
                                                    <?php echo Year($vehicle); ?>
                                                </p>
                                                <p class="vehicle__mileage">
                                                    <?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
                                                </p>
                                            </div>
                                            <div class="vehicle__action">
                                                <button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
                                            </div>
                                        </div>
                                        <div class="vehicle__footer">
                                            <div class="vehicle__location">
                                                <?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
                                            </div>
                                            <div class="vehicle__icons">
                                                <span onclick="Like(<?php echo $vehicle['id'] ?>, this); Remove('<?php echo $vehicle['code'] ?>')" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
                                                    <?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
                                                    <?php } else { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
                                                    <?php } ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div id="rows__boat">
                            <div class="row gx-3">
                                <?php 

                                $consulta = "SELECT vehicles.*,
                                                    brands.name AS brand_name 

                                                    FROM vehicles 
                                                    LEFT JOIN brands ON brands.id = vehicles.brand

                                                    WHERE vehicles.status = 1
                                                    AND vehicles.type = 'boat'
                                                    AND vehicles.id IN (SELECT vehicle FROM likes WHERE user = '$user_id')";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($vehicle = $con->fetch_array()) { 

                                    if (!empty($vehicle['photos'])) {
                                        $vehicle['photos'] = json_decode($vehicle['photos'], true);
                                        $attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
                                    }

                                ?>
                                <div id="<?php echo $vehicle['code']; ?>" class="col-6 col-lg-3 col-xl-3">
                                    <div class="vehicle__item">
                                        <div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
                                            <div 
                                                 <?php if (isset($vehicle['photos'][1])) { ?>
                                                 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
                                                 <?php } ?>

                                                 <?php if (isset($vehicle['photos'][0])) { ?>
                                                 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
                                                 <?php } ?>

                                                 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
                                                 class="picture__item"
                                            ></div>
                                        </div>
                                        <div class="vehicle__details">
                                            <h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
                                            <p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes"><?php echo strtoupper($vehicle['engine'] . ' ' . $vehicle['fuel'] . ' ' . $vehicle['transmission']); ?></p>
                                            <h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
                                            <div class="vehicle__statistics">
                                                <p class="vehicle__year">
                                                    <?php echo Year($vehicle); ?>
                                                </p>
                                                <p class="vehicle__mileage">
                                                    <?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
                                                </p>
                                            </div>
                                            <div class="vehicle__action">
                                                <button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
                                            </div>
                                        </div>
                                        <div class="vehicle__footer">
                                            <div class="vehicle__location">
                                                <?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
                                            </div>
                                            <div class="vehicle__icons">
                                                <span onclick="Like(<?php echo $vehicle['id'] ?>, this); Remove('<?php echo $vehicle['code'] ?>')" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
                                                    <?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
                                                    <?php } else { ?>
                                                    <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
                                                    <?php } ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div id="rows__nothing">
                            <h1>Sem favoritos por enquanto.</h1>
                            <p>Gostou de um anúncio? Clica no coração que ele vem pra cá!</p>
                            <button onclick="Route('')">Buscar ofertas</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

    var currentBox = 'car';

    function Toggle(box) {
        currentBox = box;

        const boxes = {
            car: document.getElementById('rows__car'),
            motorcycle: document.getElementById('rows__motorcycle'),
            boat: document.getElementById('rows__boat')
        };

        const buttons = {
            car: document.getElementById('button__car'),
            motorcycle: document.getElementById('button__motorcycle'),
            boat: document.getElementById('button__boats')
        };

        Object.values(boxes).forEach(box => box.style.display = 'none');
        Object.values(buttons).forEach(button => button.classList.remove('row__active'));

        if (boxes[box]) {
            boxes[box].style.display = 'block';
        }
        if (buttons[box]) {
            buttons[box].classList.add('row__active');
        }

        CheckNothing(boxes[box]);

    }

    function CheckNothing(toggle = false) {
        const boxNothing = document.getElementById('rows__nothing');
        if (toggle) {
            const elements = toggle.querySelectorAll('.vehicle__item');
            elements.length === 0 ? boxNothing.style.display = 'flex' : boxNothing.style.display = 'none';
        } else {
            const elements = document.querySelectorAll('.vehicle__item');
            elements.length === 0 ? boxNothing.style.display = 'flex' : boxNothing.style.display = 'none';
        }
    }

    Toggle('car');

    function HoverPicture(action, file, box) {
        box.style.background = 'url("' + file + '")';
    }

    function Remove(id) {
        document.getElementById(id).remove();
        Toggle(currentBox);
    }

    // Conta os likes
    document.addEventListener('DOMContentLoaded', function() {
        CheckNothing();
    });

</script>
</html>