<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/templates/footer.css'; ?>">

<div id="footer">
    <div class="container">
        <div class="row">
            <div class="col-11 col-md-3 mx-auto">
                <div onclick="Route('')" class="footer__logo">
                    <img src="<?php echo $local['brands'] . '/inline-black-fill.png'; ?>">
                </div>
                <div class="footer__description">
                    <?php echo $seo['description']; ?>
                </div>
                <div class="footer__language">
                    <select id="nice-select">
                        <option value="pt-br">🇧🇷⠀Português</option>
                        <option value="en">🇺🇸⠀English</option>
                    </select>
                </div>
            </div>
            <div class="col-11 col-md-1 mx-auto"></div>
            <div class="col-11 col-md-8 mx-auto">
                <div class="footer__columns">
                    <div class="footer__menu">
                        <h3>Sobre</h3>
                        <hr>
                        <a class="footer__link" href="<?php echo Route('about'); ?>">Sobre nós</a>
                        <a class="footer__link" href="<?php echo Route('privacy-policies'); ?>">Política de privacidade</a>
                        <a class="footer__link" href="<?php echo Route('terms-of-use'); ?>">Termos de serviço</a>
                        <div class="footer__social">
                            <a href="<?php echo $social['facebook']; ?>" target="_blank">
                                <div class="footer__icon">
                                    <img src="<?php echo $local['assets'] . '/icons/facebook.png'; ?>">
                                </div>
                            </a>
                            <a href="<?php echo $social['instagram']; ?>" target="_blank">
                                <div class="footer__icon">
                                    <img src="<?php echo $local['assets'] . '/icons/instagram.png'; ?>">
                                </div>
                            </a>
                            <a href="<?php echo $social['youtube']; ?>" target="_blank">
                                <div class="footer__icon">
                                    <img src="<?php echo $local['assets'] . '/icons/youtube.png'; ?>">
                                </div>
                            </a>
                            <a href="<?php echo $social['twitter']; ?>" target="_blank">
                                <div class="footer__icon">
                                    <img src="<?php echo $local['assets'] . '/icons/twitter.png'; ?>">
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="footer__menu footer__mobile__hide">
                        <h3>Marcas</h3>
                        <hr>
                        <?php 
                        $consulta = "SELECT * FROM brands ORDER BY hits DESC LIMIT 10";
                        $con = $conn->query($consulta) or die($conn->error);
                        while($brand = $con->fetch_array()) { ?>
                        <a class="footer__link" onclick="BrandHit(<?php echo $brand['id']; ?>)" href="<?php echo Route('search?bn=' . $brand['name'] . '&bi=' . $brand['id']); ?>"><?php echo $brand['name']; ?></a>
                        <?php } ?>
                    </div>
                    <div class="footer__menu footer__mobile__hide">
                        <h3>Atalhos</h3>
                        <hr>
                        <?php 
                        $consulta = "SELECT * FROM categories ORDER BY hits DESC LIMIT 10";
                        $con = $conn->query($consulta) or die($conn->error);
                        while($category = $con->fetch_array()) { ?>
                        <a class="footer__link" onclick="CategoryHit(<?php echo $category['id']; ?>)" href="<?php echo Route('search?cn=' . $category['name'] . '&ci=' . $category['id']); ?>"><?php echo $category['name']; ?></a>
                        <?php } ?>
                    </div>
                    <div class="footer__menu">
                        <h3>Suporte</h3>
                        <hr>
                        <a class="footer__link" href="<?php echo Route('help'); ?>">Central de ajuda</a>
                        <a class="footer__link" href="<?php echo Route('help/#contact'); ?>">Canais de atendimento</a>
                        <a class="footer__link" href="<?php echo Route('help/#ombudsman'); ?>">Ouvidoria</a>
                        <div onclick="Route('help/#chat');" class="footer__chat">
                            <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16.1892 12.413H16.1982"stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M12.1802 12.413H12.1892"stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M8.17116 12.413H8.18016"stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M19.3212 4.92704C23.2302 8.83604 23.2222 15.168 19.3212 19.07C16.2662 22.126 11.7402 22.787 8.03617 21.074C7.49017 20.854 3.95117 21.834 3.18317 21.067C2.41617 20.299 3.39617 16.76 3.17617 16.213C1.46317 12.51 2.12417 7.98304 5.18017 4.92704C8.10617 2.00004 12.4032 1.26804 16.0142 2.73204" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <p>Fale conosco</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="footer__copy">
    <p><?php echo $app['name']; ?> © 2024 - 00.000.000/0000-00 - Todos os direitos reservados.<br></p>
</div>

<script type="text/javascript"> 
    NiceSelect.bind(document.getElementById("nice-select"), {searchable: false});
</script>