<?php 

    session_start();
    require_once __DIR__ . '/../../inc/conn.php';
    require_once __DIR__ . '/../../libs/vendor/autoload.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\SMTP;
    use PHPMailer\PHPMailer\Exception;

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Declara as variáveis
        $name = $_POST['name'];
        $email = $_POST['email'];
        $telephone = $_POST['telephone'];
        $message = $_POST['message'];
        $seller = $_POST['seller'];
        $vehicle_id = $_POST['vehicle'];
        $vehicle_link = $_POST['link'];

        // Busca as informações do vendedor
        $sellerQuery = "SELECT id, email, name FROM users WHERE id = '$seller'";
        $sellerResult = $conn->query($sellerQuery);
        $seller = $sellerResult->fetch_array();

        // Busca as informações do veículo
        $vehicleQuery = "SELECT vehicles.id,
                                vehicles.model,
                                brands.name AS brand_name 

                                FROM vehicles 
                                LEFT JOIN brands ON brands.id = vehicles.brand

                                WHERE vehicles.id = '$vehicle_id'";

        $vehicleResult = $conn->query($vehicleQuery);
        $vehicle = $vehicleResult->fetch_assoc();
        $vehicle['link'] = $vehicle_link;

        $formatted__time = date('d/m/Y h:i');

        // Dispara o e-mail
        $mail = new PHPMailer(true);

        try {

            $mail->isSMTP();
            $mail->Host       = 'smtp.hostinger.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'noreply@carlospeterson.cloud';
            $mail->Password   = 'lkWXk532[)!Z';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;

            //Recipients
            $mail->setFrom('noreply@carlospeterson.cloud', 'My Motors | No Reply');
            $mail->addAddress($seller['email'], $seller['name']);

            // Pega a estrutura
            ob_start();
            include __DIR__ . '/../../assets/mails/pt-br/vehicles/contact.php';
            $mailBody = ob_get_clean();

            //Content
            $mail->isHTML(true);
            $mail->Subject = utf8_encode('Novo contato | My Motors');
            $mail->Body = $mailBody;

            $mail->send();

        } catch (Exception $e) {

            $response = array(
                'status' => 'error',
                'message' => 'Erro ao disparar o e-mail.',
            );

            http_response_code(503);
            echo json_encode($response);
            end();

        }

        // Adiciona o e-mail na newslatter
        $newslatter = isset($_POST['newslatter']) ? $_POST['newslatter'] : null;
        if ($newslatter == 'true') {
            $newslatterQuery = "INSERT IGNORE INTO newsletter (name, email) VALUES (?, ?)";
            @$stmt = $conn->prepare($newslatterQuery);
            @$stmt->bind_param('ss', $name, $email);
            @$stmt->execute();
            @$stmt->close();
        }

        // Insere o contato no db
        $query = "INSERT INTO contacts (seller, vehicle, name, email, telephone, message)
                  VALUES (?, ?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($query);
        $stmt->bind_param('ssssss', $seller['id'], $vehicle_id, $name, $email, $telephone, $message);

        $result = $stmt->execute();
        $stmt->close();

        // Retorna a response
        $response = array(
            'status' => 'success'
        );

        http_response_code(200);
        echo json_encode($response);

    } else { http_response_code(400); }

?>