<?php 

    session_start();
    header('Content-type: application/json');

    $removeJs = true;
    require_once __DIR__ . '/../../inc/conn.php';
    require_once __DIR__ . '/../../inc/config.php';
    require_once __DIR__ . '/../../inc/functions.php';


    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $type = isset($_POST['type']) ? $_POST['type'] : null;
        $query = !empty($_POST['query']) ? $_POST['query'] : null;
        $get = !empty($_POST['filter_get']) ? $_POST['filter_get'] : null;
        
        $condition = '';
        $sort = '';

        if ($type) { $condition = "AND vehicles.type = '$type'"; }
        if ($get) {

            $condition = '';

            switch ($get['type']) {
                case 'category':
                    $category_id = $get['id'];
                    $condition = "AND vehicles.category = '$category_id'";
                    break;

                case 'brand':
                    $brand_id = $get['id'];
                    $condition = "AND vehicles.brand = '$brand_id'";
                    break;

                case 'seller':
                    $seller_id = $get['id'];
                    $condition = "AND vehicles.seller = '$seller_id'";
                    break;
                
                default:
                    break;
            }

        }
        if ($query) { $condition = "AND (CONCAT(brands.name, ' ', vehicles.model, ' ', vehicles.engine) LIKE '%$query%' OR SOUNDEX(CONCAT(brands.name, ' ', vehicles.model, ' ', vehicles.engine)) = SOUNDEX('%$query%'))"; }

        // Filters
        if (isset($_POST['filters']) && !empty($_POST['filters'])) {
            $filters = $_POST['filters'];

            // Preço mínimo
            if (!empty($filters['p_min'])) {
                $min_price = UnmaskMoney($filters['p_min']);
                $condition .= " AND vehicles.price >= '$min_price' ";
            }

            // Preço máximo
            if (!empty($filters['p_max'])) {
                $max_price = UnmaskMoney($filters['p_max']);
                $condition .= " AND vehicles.price <= '$max_price' ";
            }

            // Quilometragem mínima
            if (!empty($filters['k_min'])) {
                $min_mileage = intval(str_replace('.', '', $filters['k_min']));
                $condition .= " AND vehicles.mileage >= '$min_mileage' ";
            }

            // Quilometragem máxima
            if (!empty($filters['k_max'])) {
                $max_mileage = intval(str_replace('.', '', $filters['k_max']));
                $condition .= " AND vehicles.mileage <= '$max_mileage' ";
            }

            // Ano mínimo
            if (!empty($filters['y_min'])) {
                $min_year = intval($filters['y_min']);
                $condition .= " AND LEAST(vehicles.year_build, vehicles.year_model) >= '$min_year' ";
            }

            // Ano máximo
            if (!empty($filters['y_max'])) {
                $max_year = intval($filters['y_max']);
                $condition .= " AND GREATEST(vehicles.year_build, vehicles.year_model) <= '$max_year' ";
            }

            // Marca
            if (!empty($filters['b'])) {
                $brands = is_array($filters['b']) ? implode(',', $filters['b']) : $filters['b'];
                $condition .= " AND brand IN ($brands) ";
            }

			// Transmission
			if (!empty($filters['t'])) {
			    $transmissions = is_array($filters['t']) ? "'" . implode("','", array_map('strval', $filters['t'])) . "'" : "'" . $filters['t'] . "'";
			    $condition .= " AND transmission IN ($transmissions) ";
			}

			// Fuel
			if (!empty($filters['f'])) {
			    $fuels = is_array($filters['f']) ? "'" . implode("','", array_map('strval', $filters['f'])) . "'" : "'" . $filters['f'] . "'";
			    $condition .= " AND fuel IN ($fuels) ";
			}


        }

        // ================= SORT

        $sort_by = isset($filters['sort']) ? $filters['sort'] : 'most_relevant';

        switch ($sort_by) {
            case 'most_relevant':
                $sort .= "vehicles.hits DESC,";
                break;
            case 'biggest_price':
                $sort .= "vehicles.price DESC, ";
                break;
            case 'lowest_price':
                $sort .= "vehicles.price ASC, ";
                break;
            case 'newer_year':
                $sort .= "vehicles.year_model DESC, ";
                break;
            case 'mileage':
                $sort .= "vehicles.mileage ASC, ";
                break;
            default:
                $sort .= "";
                break;
        }

        // Busca os veículos no banco de dados
        $search_query = "
            SELECT vehicles.*,
                   brands.name AS brand_name

            FROM vehicles
            LEFT JOIN brands ON brands.id = vehicles.brand

            WHERE status = 1
            $condition
            
            ORDER BY $sort vehicles.hits DESC, inserted_at DESC
        ";

        $transmissions = [];
        $brands = [];
        $fuels = [];
        $rows = [];

        $con = $conn->query($search_query) or die($conn->error);
        while($row = $con->fetch_assoc()) {

            // Organiza o array
            $row['route'] = VehicleRoute($row);
            $row['title'] = mb_strtoupper($row['brand_name'] . ' ' . $row['model']);

            if ($row['type'] == 'boat') {
                $row['year'] = $row['year_build'];
                $row['subtitle'] = !empty($row['feet']) ? $row['feet'] . ' pés'  : '';
            } else {
                $row['subtitle'] = $row['type'] == 'car' ? mb_strtoupper($row['engine'] . ' ' . Fuel($row['fuel']) . ' ' . Transmission($row['transmission']), 'UTF-8') : '';
                $row['year'] = $row['year_build'] . '/' . $row['year_model'];
            }

            $row['photos'] = !empty($row['photos']) ? json_decode($row['photos'], true) : null;
            $attachment = $local['assets'] . '/attachments/vehicles/' . $row['code'];

            $row['formated_price'] = '$ ' . number_format($row['price'], 0, ',', '.');
            $row['n_mileage'] = $row['mileage'];
            $row['mileage'] = Mileage($row['mileage'], $row['type']);

            $row['year'] = Year($row);

            $row['city'] = !empty($row['city']) ? $row['city'] : '';
            $row['state'] = !empty($row['state']) ? $row['state'] : '';

            // Verifica o like
            if (isset($user['likes']) && in_array($row['id'], $user['likes'])) {
                $row['like'] = true;
            } else {
                $row['like'] = false;
            }

            // Traduz o combustível
            $row['fuel_ptbr'] = Fuel($row['fuel']);

            // Traduz o câmbio
            $row['transmission_ptbr'] = Transmission($row['transmission']);

            // Intera o array
            $brands[] = ['id' => $row['brand'], 'name' => $row['brand_name']];
            $row['fuel_ptbr'] ? $fuels[] = ['en' => $row['fuel'], 'pt' => $row['fuel_ptbr']] : null;
            $row['transmission'] ? $transmissions[] = ['en' => $row['transmission'], 'pt' => $row['transmission_ptbr']] : null;
            $rows[] = $row;

        }

        $page = !empty($_POST['page']) ? intval($_POST['page']) : 1;
        $per_page = !empty($_POST['per_page']) ? $_POST['per_page'] : 12;

        function Paginate($array, $page, $per_page) {
            $offset = ($page - 1) * $per_page;
            $array_paginado = array_slice($array, $offset, $per_page, false);
            return $array_paginado;
        }

        $rows_paginated = Paginate($rows, $page, $per_page);

        $response = array(
            'status' => 'success',
            'total' => ['show' => count($rows_paginated), 'all' => count($rows)],
            'rows' => $rows_paginated,
            'filter' => !empty($_POST['filters']) ? $_POST['filters'] : '',
            'transmissions' => $transmissions,
            'brands' => $brands,
            'fuels' => $fuels,
        );

        // Envia a response
        http_response_code(200);
        echo json_encode($response);

    } else { http_response_code(400); }

?>